/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.service.wight.core;

import global.namespace.service.wight.annotation.ServiceImplementation;
import global.namespace.service.wight.core.CompositeProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class ServiceLocator {
    private static final Comparator<Supplier<?>> PROVIDER_COMPARATOR = Comparator.comparingInt(provider -> Optional.ofNullable(provider.getClass().getDeclaredAnnotation(ServiceImplementation.class)).map(ServiceImplementation::priority).orElse(0)).reversed();
    private static final Comparator<UnaryOperator<?>> FILTER_COMPARATOR = Comparator.comparingInt(mapping -> Optional.ofNullable(mapping.getClass().getDeclaredAnnotation(ServiceImplementation.class)).map(ServiceImplementation::priority).orElse(0));
    private final Optional<ClassLoader> classLoader;

    public ServiceLocator() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ServiceLocator(ClassLoader cl) {
        this.classLoader = Optional.ofNullable(cl);
    }

    public <S, SP extends Supplier<S>> CompositeProvider<S, SP, ? extends UnaryOperator<S>> provider(Class<SP> provider) {
        return this.provider(provider, Optional.empty());
    }

    public <S, SP extends Supplier<S>, SF extends UnaryOperator<S>> CompositeProvider<S, SP, SF> provider(Class<SP> provider, Class<SF> filter) {
        return this.provider(provider, Optional.of(filter));
    }

    private <S, SP extends Supplier<S>, SF extends UnaryOperator<S>> CompositeProvider<S, SP, SF> provider(Class<SP> factory, Optional<Class<SF>> filter) {
        return new CompositeProvider(this.providers(factory), filter.map(this::filters).orElseGet(Collections::emptyList));
    }

    private <S, SP extends Supplier<S>> List<SP> providers(Class<? extends SP> service) {
        ArrayList providers = new ArrayList();
        this.instancesOf(service).forEach(providers::add);
        providers.sort(PROVIDER_COMPARATOR);
        this.instanceOf(service).map(s -> {
            providers.add(0, (Supplier<?>)s);
            return null;
        });
        if (providers.isEmpty()) {
            throw new ServiceConfigurationError("No service located for " + service + ".");
        }
        return providers;
    }

    private <S, SF extends UnaryOperator<S>> List<SF> filters(Class<? extends SF> service) {
        ArrayList mappings = new ArrayList();
        this.instancesOf(service).forEach(mappings::add);
        mappings.sort(FILTER_COMPARATOR);
        return mappings;
    }

    private <S> ServiceLoader<S> instancesOf(Class<S> service) {
        return ServiceLoader.load(service, this.classLoader.orElse(null));
    }

    private <S> Optional<S> instanceOf(Class<S> service) {
        return Optional.ofNullable(System.getProperty(service.getName())).map(name -> {
            try {
                return service.cast(Class.forName(name, false, this.classLoader.orElse(null)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ServiceConfigurationError(e.toString(), e);
            }
        });
    }
}

